package com.adamsearle.utils {
	import flash.display.*;
	import flash.media.*;
	import flash.net.*;
	import flash.events.*;
	
	public class BackgroundMusicPlayer {
		private var _sound:Sound;
		private var _channel:SoundChannel;
		private var _status:int;
		private var _looping:Boolean;
		private var _pausePosition:int;
		
		public static const MUSIC_PLAYING:int = 1;
		public static const MUSIC_PAUSED:int = 2;
		public static const MUSIC_PLAYING_SUSPENDED:int = 3; 	// used when video is playing, music must halt, but records 
																// users preference to have it return upon unhalting
		public static const MUSIC_PAUSED_SUSPENDED:int = 4;
		
		
		public function BackgroundMusicPlayer(url:String) {
			trace("BackgroundMusicPlayer instantiated");
			
			// Load the request, create the objects
			var request:URLRequest = new URLRequest(url);
			_sound = new Sound();
			_channel = new SoundChannel();
			_sound.load(request);
			
			// Set the playback parameters
			_looping = true;
			
			// Set status paused, wait to be asked to play
			_status = MUSIC_PAUSED;
			
			// Error handler
			_sound.addEventListener(IOErrorEvent.IO_ERROR, errorHandler);
		}

		// Internal control to play, no status monitoring
		private function playTrack():void {
			var position:int = 0;
			if (_pausePosition != 0) {
				position = _pausePosition;
				_pausePosition = 0;
			}
			_channel = _sound.play(position);
			_channel.addEventListener(Event.SOUND_COMPLETE, soundCompleteHandler);
		}

		// Internal control to stop, no status monitoring		
		private function stopTrack():void {
			_pausePosition = _channel.position;
			_channel.stop();
		}
		
		// External control for user pressing play button - no toggle (will always go to a play)
		public function playHandler():void {

			if (_status == MUSIC_PLAYING) {
				// Nothing
				
			} else if (_status == MUSIC_PAUSED) {
				_status = MUSIC_PLAYING;
				playTrack();
			}
		}
		
		// External control for user pressing pause button - no toggle (will always go to a paused)
		public function pauseHandler():void {

			if (_status == MUSIC_PLAYING) {
				_status = MUSIC_PAUSED;
				stopTrack();
				

			} else if (_status == MUSIC_PAUSED) {
				// Nothing
			}
		}
		
		// External control for toggling play/pause
		public function toggleHandler():void {
			//trace("toggleHandler");
			
			// If playing
			if (_status == MUSIC_PLAYING) {
				_status = MUSIC_PAUSED;
				stopTrack();
				
			// If paused
			} else if (_status == MUSIC_PAUSED) {
				_status = MUSIC_PLAYING;
				playTrack();
			}
		}
		
		// External control for entering suspension (paused while eg video plays)
		public function beginSuspension():void {
			
			if (_status == MUSIC_PLAYING) {
				_status = MUSIC_PLAYING_SUSPENDED;
				stopTrack();
				
			} else if (_status == MUSIC_PAUSED) {
				_status = MUSIC_PAUSED_SUSPENDED;
			}
		}
		
		// External control for ending suspension (paused while eg video plays)
		public function endSuspension():void {

			if (_status == MUSIC_PLAYING_SUSPENDED) {
				_status = MUSIC_PLAYING;
				playTrack();

			} else if (_status == MUSIC_PAUSED_SUSPENDED) {
				_status = MUSIC_PAUSED;
			}
		}
		
		// Sound complete
		private function soundCompleteHandler(e:Event):void {
			trace("soundCompleteHandler");
			if (_looping) {
				playTrack();
			}
		}
		
		// IO error handler
		private function errorHandler(errorEvent:IOErrorEvent):void {
			trace("BackgroundMusicPlayer couldnt load file, error: " + errorEvent.text);
		}
	}
}